class CheckNewDarkVersion extends SqRootScript
{
    // Sends TurnOn to all ControlDevice links if
    // the game is not NewDark 1.26 (or later)
    function OnSim()
    {
        if (message().starting) {
            local required_major_version = 1;
            local required_minor_version = 28;

            local major_version = int_ref();
            local minor_version = int_ref();
            Version.GetVersion(major_version, minor_version);
            print("NewDark version is " + major_version + "." + minor_version
                + ", mission requires version " + required_major_version + "." + required_minor_version);

            local bad_major_version = (major_version.tointeger() < required_major_version);
            local bad_minor_version = ((major_version.tointeger() == required_major_version)
                && (minor_version.tointeger() < required_minor_version));
            if (bad_major_version || bad_minor_version) {
                Link.BroadcastOnAllLinks(self, "TurnOn", "ControlDevice");
            }
        }
    }
}